/* lanchat - a small GTK+ tool which uses broadcasts
 * to make it possible to chat in a LAN without a dedicated
 * server
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * (c) by ScriptKiller
 *
 * Version 0.1 15.09.2001
 * Version 0.2 15.09.2001 one could say it works ;)
 * Version 0.3 16.09.2001 fixed a bug with RedHat 7.1 when
 *                        entering non ASCII characters (call to
 *                        gtk_set_locale() added)
 *
 * BUGS: doesn't work over subnets ... this is because
 *       of the broadcasts, they won't jump to another
 *       subnet.
 *
 */

#include <stdio.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <stdlib.h>
#include <sys/types.h>
#include <string.h>
#include <gtk/gtk.h>
#include <fcntl.h>

#define VERSION "0.3"
#define DEFAULTPORT 31111

void lanchat_create_gui(void);
void lanchat_window_close(GtkWidget *, gpointer);
void lanchat_set_status(char *);
void lanchat_data_arrived(gpointer, int, GdkInputCondition);
void lanchat_send_message(GtkWidget *, gpointer);

/* globals */
GtkWidget *statusbar;
GtkWidget *text;
int s;
struct sockaddr *client;

int main(int argc, char *argv[]) {

  int on=1;
  int port;
  struct sockaddr_in in;
  struct sockaddr_in cli;
  char *broadcast_address;

  gtk_set_locale();

  gtk_init(&argc, &argv);

  /* port stuff */
  if(argc==2) {
    port=DEFAULTPORT;
  }
  else if(argc==3) {
    port=atoi(argv[2]);
  }
  else {
    fprintf(stderr, "Usage: %s [gtk_options] broadcast_address [port]\n", argv[0]);
    exit(1);
  }

  broadcast_address=argv[1];

  /* try to create listen socket and set it up! */
  /* sockaddr_in */
  in.sin_family=AF_INET;
  in.sin_port=htons(port);
  in.sin_addr.s_addr=INADDR_ANY;

  /* socket */
  if((s=socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
    perror("socket failed");
    exit(1);
  }

  /* enable broadcast */
  if(setsockopt(s, SOL_SOCKET, SO_BROADCAST, &on, sizeof(on)) == -1) {
    perror("setsockopt (SO_BROADCAST) failed");
    exit(1);
  }

  if(bind(s, (struct sockaddr *)&in, sizeof(struct sockaddr_in)) == -1) {
    perror("bind failed");
    exit(1);
  }

  /* make non blocking */
  if(fcntl(s, F_SETFL, O_NONBLOCK) == -1) {
    perror("fcntl failed");
    exit(1);
  }

  /* init sockaddr_in struct for the client part */
  cli.sin_family=AF_INET;
  cli.sin_port=htons(port);
  if(inet_aton(broadcast_address, &cli.sin_addr) == 0) {
    perror("inet_aton failed");
    exit(1);
  }

  /* make global */
  client=(struct sockaddr *)&cli;

  /* create gui */
  lanchat_create_gui();

  /* add a select handler */
  gdk_input_add(s, GDK_INPUT_READ, lanchat_data_arrived, NULL);

  gtk_main();

  exit(0);

}

void lanchat_create_gui() {

  GtkWidget *window;
  GtkWidget *vbox;
  GtkWidget *input_hbox;
  GtkWidget *input_entry;

  /* window */
  window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "Lanchat "VERSION" by ScriptKiller");
  gtk_window_set_default_size(GTK_WINDOW(window), 320, 240);
  gtk_signal_connect(GTK_OBJECT(window), "destroy", lanchat_window_close, NULL);

  /* main box */
  vbox=gtk_vbox_new(0, 0);

  /* text */
  text=gtk_text_new(0, 0);
  gtk_box_pack_start(GTK_BOX(vbox), text, 1, 1, 0);

  /* input */
  input_entry=gtk_entry_new();
  gtk_entry_set_editable(GTK_ENTRY(input_entry), 1);
  gtk_signal_connect(GTK_OBJECT(input_entry), "activate", lanchat_send_message, NULL);
  input_hbox=gtk_hbox_new(0, 0);
  gtk_box_pack_start(GTK_BOX(input_hbox), gtk_label_new("Text: "), 0, 0, 0);
  gtk_box_pack_start(GTK_BOX(input_hbox), input_entry, 1, 1, 0);
  gtk_box_pack_start(GTK_BOX(vbox), input_hbox, 0, 0, 0);

  /* statusbar */
  statusbar=gtk_entry_new();
  gtk_entry_set_editable(GTK_ENTRY(statusbar), 0);
  //  gtk_box_pack_start(GTK_BOX(vbox), statusbar, 0, 0, 0);


  /* visible */
  gtk_container_add(GTK_CONTAINER(window), vbox);
  gtk_widget_show_all(window);

}

void lanchat_window_close(GtkWidget *w, gpointer data) {

  gtk_main_quit();

}

/* sets the status bar */
void lanchat_set_status(char *status) {

  gtk_entry_set_text(GTK_ENTRY(statusbar), status);

}

/* called when new data has arrived */
void lanchat_data_arrived(gpointer data, int s, GdkInputCondition cond) {

  char buffer[1024];
  int size;
  int bytes;
  struct sockaddr_in in;

  /* loop */
  while(1) {

    int size=sizeof(struct sockaddr_in);

    if((bytes=recvfrom(s, buffer, sizeof(buffer), 0, (struct sockaddr *)&in, &size)) > 0) {
      /* okay */
      buffer[bytes]='\0';

      printf("Received \"%s\" from %s\n", buffer, inet_ntoa(in.sin_addr));

      gtk_text_freeze(GTK_TEXT(text));
      gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL, inet_ntoa(in.sin_addr), -1);
      gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL, ": ", -1);
      gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL, buffer, -1);
      gtk_text_thaw(GTK_TEXT(text));
      gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL, "\n", -1);
    }
    else {
      perror("recvfrom failed");
      return;
    }

  }

}

void lanchat_send_message(GtkWidget *w, gpointer data) {

  char *text=gtk_entry_get_text(GTK_ENTRY(w));

  /* flush entry */
  gtk_entry_set_text(GTK_ENTRY(w), "");

  /* send it */
  if(sendto(s, text, strlen(text), 0, client, sizeof(*client)) < 0) {
    perror("sendto failed");
    exit(1);
  }

}
